#!/usr/bin/tclsh
# Add files to files.bbs

source config

proc ProcessDir {dir desc} {
	global FNlength ignorenames fileslist
	
	if [catch {set infile [open $dir/$fileslist]}] {
		puts stderr "$fileslist not exists in $dir"
		return
	}
# Read files list from files.bbs
	set files {}
	while {[gets $infile line] >= 0} {
		# check for empty and comment lines
		set firstchar [string index $line 0]
		if {$firstchar == " " || $firstchar == "\t" || $firstchar == ""} {
			continue
		}
		scan $line "%s" file
		lappend files $file
	}
	close $infile
# Now read directory and search for missing files
	set outfile [open $dir/$fileslist a]
	foreach {file} [glob -nocomplain $dir/*] {
		if {[file type $file] != "file"} {
			continue
		}
		if {[lsearch -exact $ignorenames [file tail $file]] != -1} {
			continue
		}
		set file [file tail $file]
		if {[lsearch -exact $files $file] == -1} {
			puts stderr "Added $file to list"
			puts $outfile [format "%-${FNlength}s - (Autoadded)" $file]
		}
	}
	close $outfile
}

foreach {dir} $path {
	set desc [lindex $dir 1]
	set dir [lindex $dir 0]
	if [file exists $dir] {
		puts stderr "Processing $dir $desc ..."
		ProcessDir $dir $desc
	} else {
		puts stderr "Directory $dir does not exists!"
	}
}
