#!/usr/bin/tclsh
# Removes missing files from files.bbs

source config

proc ProcessDir {dir desc} {
	global fileslist

	if [catch {set infile [open $dir/$fileslist]}] {
		puts stderr "$fileslist not exists in $dir"
		return
	}
	set outfile [open $dir/files.temp w]
	while {[gets $infile line] >= 0} {
		# check for empty and comment lines
		set firstchar [string index $line 0]
		if {$firstchar == " " || $firstchar == "\t" || $firstchar == ""} {
			puts $outfile $line
			continue
		}
		scan $line "%s" file
		if [file exists $dir/$file] {
			puts $outfile $line
		} else {
			puts stderr "File $file deleted from list"
		}
	}
	close $infile
	close $outfile
	file rename -force -- $dir/files.temp $dir/$fileslist
}

foreach {dir} $path {
	set desc [lindex $dir 1]
	set dir [lindex $dir 0]
	if [file exists $dir] {
		puts stderr "Processing $dir $desc ..."
		ProcessDir $dir $desc
	} else {
		puts stderr "Directory $dir does not exists!"
	}
}
