{$IFDEF FPC}
	{$D-,E-,I-,L-,P-,Q-,R-,S-,T-,V-,X+,Y-}
	{$M 16384}

	USES Dos, StrMan;
{$ELSE}
	{$IFDEF VIRTUALPASCAL}
		{$A+,B-,D-,G3+,LocInfo-,I-,L-,M-,P-,Q-,R-,S-,T-,V-,X+}
		{$M 16384}

		USES Use32, Dos, StrMan;
	{$ELSE}
		{$IFDEF VER70}
			{$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y-}
			{$M 16384,0,655360}

			USES Dos, StrMan;
		{$ELSE}
			{$IFDEF __TMT__}
				{$A+,B-,D-,I-,L-,P-,Q-,R-,S-,T-,V-,X+}

				USES Dos, StrMan;
			{$ELSE}
				This program can be compiled only with VP, BP7, TMTP and FPC compilers!
			{$ENDIF}
		{$ENDIF}
	{$ENDIF}
{$ENDIF}

TYPE
	T4DAddress = RECORD
		Zone: Integer;
		Net: Integer;
		Node: Integer;
		Point: Integer;
	END;

	PFileBox = ^TFileBox;
	TFileBox = RECORD
		Address: T4DAddress;
		Directory: String;
		Next: PFileBox;
	END;

	PFile = ^TFile;
	TFile = RECORD
		FileName: String;
		DestinationDirectory: ^String;
		Next: PFile;
	END;

CONST
	BufferSize = $6000;
	ConfigFileName = 'MOVE2BOX.CTL';
	LastCallFileName = 'MOVE2BOX.LAS';
	cfgTMailLog = 'TMAILLOGFILE';
	cfgIncomingDirectory = 'INCOMINGDIRECTORY';
	IncomingDirectoryStringCountMax = 64;
	cfgDefFileBox = 'FILEBOX';
	cfgOverwrite = 'OVERWRITE';
	cfgFileReceivedString = 'FILERECEIVEDSTRING';
	FileReceivedStringCountMax = 64;
	cfgIgnoreFilesString = 'IGNOREFILES';
	IgnoreFilesStringCountMax = 64;

	charComment = ';';
	strOK = 'OK';

CONST
	cmdMove = 'MOVE';
	cmdCopy = 'COPY';
	boolTrue = 'YES';
	boolFalse = 'NO';

VAR
	ProgramPath: String;
	TMailLogFile: String;
	FileBoxListStart: PFileBox;
	FileBoxListEnd: PFileBox;
	OverwriteIncoming: Boolean;
	FileListStart: PFile;
	FileListEnd: PFile;
	FileReceivedString: ARRAY [1..FileReceivedStringCountMax] OF String;
	FileReceivedStringCount: Integer;
	IgnoreFilesString: ARRAY [1..IgnoreFilesStringCountMax] OF String;
	IgnoreFilesStringCount: Integer;
	IncomingDirectoryString: ARRAY [1..IncomingDirectoryStringCountMax] OF String;
	IncomingDirectoryStringCount: Integer;

	TodayDay: Word;
	TodayMonth: Word;
	TodayYear: Word;

PROCEDURE DOSFileDelete (FileName: STRING);
VAR
	f: File;
BEGIN
	Assign (f, FileName);
	Erase (f);
END;

FUNCTION DirectoryExists (DirectoryName: String): Boolean;
VAR
	CurrentDirectory: String;
BEGIN
	GetDir (0, CurrentDirectory);
	ChDir (DirectoryName);
	DirectoryExists := IOResult = 0;
	ChDir (CurrentDirectory);
END;

FUNCTION BackslashAdd (DirectoryName: String): String;
BEGIN
	IF (DirectoryName = '') THEN
		BackslashAdd := ''
	ELSE
		IF (DirectoryName [Length (DirectoryName)] = ':') OR (DirectoryName [Length (DirectoryName)] = '\') THEN
			BackslashAdd := DirectoryName
		ELSE
			BackslashAdd := DirectoryName + '\';
END;

FUNCTION CreateDirectory (FileName: String): Boolean;
VAR
	CurrentPathElement: Integer;
	APath: String;
	aFileName: String;
	CurrentDisk: String;
BEGIN
	CreateDirectory := false;

	IF (StringWordCount (FileName, '\') < 2) THEN
		BEGIN
			CreateDirectory := True;
			Exit;
		END;

	IF (CharPos (':', FileName, 0) <> 0) THEN
		BEGIN
			aFileName := StringExtract (FileName, CharPos (':', FileName, 0), 255);
			CurrentDisk := FileName [1] + ':';
		END
	ELSE
		BEGIN
			aFileName := FileName;
			GetDir (0, CurrentDisk);
			CurrentDisk := CurrentDisk [1] + ':';
		END;

	FOR CurrentPathElement := 1 TO StringWordCount (aFileName, '\') - 1 DO
		BEGIN
			APath := StringExtract (aFileName, 0, StringWordPos (aFileName, '\', CurrentPathElement + 1) - 2);

			IF (NOT DirectoryExists (CurrentDisk + APath)) THEN
				BEGIN
					MkDir (CurrentDisk + APath);

					IF (IOResult <> 0) THEN
						Exit;
				END;
		END;

	CreateDirectory := True;
END;

FUNCTION ParseAddress (VAR AddressHold: T4DAddress; AddressString: String): BOOLEAN;
VAR
	i: Integer;
	s, s2: String;
BEGIN
	ParseAddress := False;

	IF (StringWordCount (AddressString, ':') <> 2) THEN
		Exit;

	s := StringWordGet (AddressString, ':', 1);

	IF (s = '*') THEN
		AddressHold.Zone := -1
	ELSE
		BEGIN
			Val (s, AddressHold.Zone, i);

			IF (i <> 0) OR (AddressHold.Zone < 0) OR (AddressHold.Zone > 9999) THEN
				Exit;
		END;

	s2 := StringWordGet (AddressString, ':.', 2);
	s := StringWordGet (s2, '/', 1);

	IF (s = '*') THEN
		AddressHold.Net := -1
	ELSE
		BEGIN
			Val (s, AddressHold.Net, i);

			IF (i <> 0) OR (AddressHold.Net < 0) OR (AddressHold.Net > 9999) THEN
				Exit;
		END;

	s := StringWordGet (s2, '/', 2);

	IF (s = '*') THEN
		AddressHold.Node := -1
	ELSE
		BEGIN
			Val (s, AddressHold.Node, i);

			IF (i <> 0) OR (AddressHold.Node < 0) OR (AddressHold.Node > 9999) THEN
				Exit;
		END;

	s := StringWordGet (AddressString, '.', 2);

	IF (s <> '') THEN
		BEGIN
			IF (s = '*') THEN
				AddressHold.Point := -1
			ELSE
				BEGIN
					Val (s, AddressHold.Point, i);

					IF (i <> 0) OR (AddressHold.Point < 0) OR (AddressHold.Point > 9999) THEN
						Exit;
				END;
		END
	ELSE
		AddressHold.Point := 0;

	ParseAddress := True;
END;

FUNCTION AddressMatching (VAR Address, AddressPattern: T4DAddress): BOOLEAN;
BEGIN
	AddressMatching := False;

	IF (AddressPattern.Zone <> -1) THEN
		BEGIN
			IF (Address.Zone <> AddressPattern.Zone) THEN
				Exit;
		END;

	IF (AddressPattern.Net <> -1) THEN
		BEGIN
			IF (Address.Net <> AddressPattern.Net) THEN
				Exit;
		END;

	IF (AddressPattern.Node <> -1) THEN
		BEGIN
			IF (Address.Node <> AddressPattern.Node) THEN
				Exit;
		END;

	IF (AddressPattern.Point <> -1) THEN
		BEGIN
			IF (Address.Point <> AddressPattern.Point) THEN
				Exit;
		END;

	AddressMatching := True;
END;

PROCEDURE ConfigurationRead;
VAR
	InFile: Text;
	InString: String;
	VariableString: String;
	ParameterString: String;
	Line: LongInt;
BEGIN
	WriteLn ('Loading configuration...');
	WriteLn;

	TMailLogFile := '';
	IncomingDirectoryStringCount := 0;
	FileReceivedStringCount := 0;
	IgnoreFilesStringCount := 0;
	OverwriteIncoming := False;
	FileBoxListStart := NIL;
	FileBoxListEnd := NIL;

	FileMode := 0;
	Assign (InFile, ProgramPath + ConfigFileName);
	Reset (InFile);

	IF (IOResult <> 0) THEN
		BEGIN
			WriteLn ('ERROR: Unable to open ' + ConfigFileName + ' configuration file!');
			Halt;
		END;

	Line := 0;

	WHILE NOT Eof (InFile) DO
		BEGIN
			Line := Line + 1;

			ReadLn (InFile, InString);

			IF (CharPos (charComment, InString, 0) <> 0) THEN
				BEGIN
					InString := StringExtract (InString, 0, CharPos (charComment, InString, 0) - 1);
				END;

			InString := StringTrimAll (InString, ' '#9);

			IF (InString <> '') THEN
				BEGIN
					IF (StringWordCount (InString, ' '#9) = 1) THEN
						BEGIN
							WriteLn ('ERROR: Meaningless definition in line ', Line, '!');
							Halt;
						END;

					VariableString := StringCase (StringWordGet (InString, ' '#9, 1), Addr (UpperCase));
					ParameterString := StringExtract (InString, StringWordPos (InString, ' '#9, 2) - 1, 255);

					IF (VariableString = cfgTMailLog) THEN
						BEGIN
							TMailLogFile := StringWordGet (ParameterString, ' '#9, 1);
						END
					ELSE
						IF (VariableString = cfgDefFileBox) THEN
							BEGIN
								IF (FileBoxListStart = NIL) THEN
									BEGIN
										FileBoxListStart := New (PFileBox);
										FileBoxListEnd := FileBoxListStart;
									END
								ELSE
									BEGIN
										FileBoxListEnd^.Next := New (PFileBox);
										FileBoxListEnd := FileBoxListEnd^.Next;
									END;

								FileBoxListEnd^.Next := NIL;

								IF (NOT ParseAddress (FileBoxListEnd^.Address, StringWordGet (ParameterString, ' '#9, 1))) THEN
									BEGIN
										WriteLn ('ERROR: Address formed incorrectly in line ', Line, '!');
										Halt;
									END;

								FileBoxListEnd^.Directory := BackslashAdd (StringWordGet (ParameterString, ' '#9, 2));

								IF (FileBoxListEnd^.Directory = '') THEN
									BEGIN
										WriteLn ('ERROR: Directory is not specified in line ', Line, '!');
										Halt;
									END;

								IF (NOT CreateDirectory (FileBoxListEnd^.Directory + 'NEWFILE')) THEN
									BEGIN
										WriteLn ('ERROR: Unable to create or access directory specified in line ', Line, '!');
										Halt;
									END;
							END
						ELSE
							IF (VariableString = cfgIncomingDirectory) THEN
								BEGIN
									IF (IncomingDirectoryStringCount >= IncomingDirectoryStringCountMax) THEN
										BEGIN
											WriteLn ('ERROR: Too many strings defined in line ', Line, '!');
											Halt;
										END;

									IncomingDirectoryStringCount := IncomingDirectoryStringCount + 1;
									IncomingDirectoryString [IncomingDirectoryStringCount] := BackslashAdd (StringWordGet (ParameterString, ' '#9, 1));
								END
							ELSE
								IF (VariableString = cfgOverwrite) THEN
									BEGIN
										ParameterString := StringCase (StringWordGet (ParameterString, ' '#9, 1), Addr (UpperCase));

										IF (ParameterString = boolTrue) THEN
											OverwriteIncoming := True
										ELSE
											IF (ParameterString = boolFalse) THEN
												OverwriteIncoming := False
											ELSE
												BEGIN
													WriteLn ('ERROR: Invalid variable value in line ', Line, '!');
													Halt;
												END;
									END
								ELSE
									IF (VariableString = cfgFileReceivedString) THEN
										BEGIN
											IF (FileReceivedStringCount >= FileReceivedStringCountMax) THEN
												BEGIN
													WriteLn ('ERROR: Too many strings defined in line ', Line, '!');
													Halt;
												END;

											FileReceivedStringCount := FileReceivedStringCount + 1;
											FileReceivedString [FileReceivedStringCount] := ParameterString;
										END
									ELSE
										IF (VariableString = cfgIgnoreFilesString) THEN
											BEGIN
												IF (IgnoreFilesStringCount >= IgnoreFilesStringCountMax) THEN
													BEGIN
														WriteLn ('ERROR: Too many strings defined in line ', Line, '!');
														Halt;
													END;

												IgnoreFilesStringCount := IgnoreFilesStringCount + 1;
												IgnoreFilesString [IgnoreFilesStringCount] := StringCase (ParameterString, Addr (UpperCase));
											END
										ELSE
											BEGIN
												WriteLn ('ERROR: Unrecognized definition in line ', Line, '!');
												Halt;
											END;
				END;
		END;

	IF (TMailLogFile = '') THEN
		BEGIN
			WriteLn ('ERROR: TMailLogFile was not specified!');
			Halt;
		END;

	IF (IncomingDirectoryStringCount = 0) THEN
		BEGIN
			WriteLn ('ERROR: At least one IncomingDirectory must be defined!');
			Halt;
		END;

	Close (InFile);
END;

PROCEDURE DateGet;
VAR
	c: Word;
BEGIN
	GetDate (TodayYear, TodayMonth, TodayDay, c);
END;

FUNCTION Older (VAR Date1, Date2: DateTime): BOOLEAN;
BEGIN
	Older := (Date2.Year > Date1.Year) OR
				(
					(Date2.Year = Date1.Year) AND
						(
							(Date2.Month > Date1.Month) OR
								(
									(Date2.Month = Date1.Month) AND
										(
											(Date2.Day > Date1.Day) OR
												(
													(Date2.Day = Date1.Day) AND
														(
															(Date2.Hour > Date1.Hour) OR
																(
																	(Date2.Hour = Date1.Hour) AND
																		(
																			(Date2.Min > Date1.Min) OR
																				(
																					(Date2.Min = Date1.Min) AND
																						(
																							(Date2.Sec > Date1.Sec)
																						)
																				)
																		)
																)
														)
												)
										)
								)
						)
				);
END;

FUNCTION CurrentDateTimeGet (VAR CurrentDate: DateTime; VAR LogString: String): Boolean;
VAR
	i: Integer;
BEGIN
	CurrentDateTimeGet := False;

	Val (StringWordGet (StringWordGet (LogString, ' ', 1), '/', 1), CurrentDate.Day, i);

	IF (i <> 0) THEN
		Exit;

	Val (StringWordGet (StringWordGet (LogString, ' ', 1), '/', 2), CurrentDate.Month, i);

	IF (i <> 0) THEN
		Exit;

	CurrentDate.Year := TodayYear;
	Val (StringWordGet (StringWordGet (LogString, ' ', 2), ':', 1), CurrentDate.Hour, i);

	IF (i <> 0) THEN
		Exit;

	Val (StringWordGet (StringWordGet (LogString, ' ', 2), ':', 2), CurrentDate.Min, i);

	IF (i <> 0) THEN
		Exit;

	Val (StringWordGet (StringWordGet (LogString, ' ', 2), ':', 3), CurrentDate.Sec, i);

	IF (i <> 0) THEN
		Exit;

	CurrentDateTimeGet := True;
END;

PROCEDURE ProcessLog;
VAR
	InFile: Text;
	LastDate: DateTime;
	CurrentDate: DateTime;
	SetDate: DateTime;
	TextBuffer: Pointer;
	InString: String;
	ProcessOpen: Boolean;
	LogString: String;
	CurrentAddress: T4DAddress;
	NewFileListStart: PFile;
	NewFileListEnd: PFile;
	CurrentFile: PFile;
	CurrentFileBox: PFileBox;
	i, j: Integer;
	FileName: String;
	FileNameUpCase: String;
BEGIN
	WriteLn ('Processing T-Mail log file...');

	FileMode := 2;
	Assign (InFile, ProgramPath + LastCallFileName);
	Reset (InFile);

	IF (IOResult <> 0) THEN
		BEGIN
			WriteLn ('INFO: Unable to open lastcall file - log will be scanned from the start.');
			SetDate.Year := 0;
			SetDate.Month := 0;
			SetDate.Day := 0;
			SetDate.Hour := 0;
			SetDate.Min := 0;
			SetDate.Sec := 0;
			ProcessOpen := True;
		END
	ELSE
		BEGIN
			ReadLn (InFile, LastDate.Year);
			ReadLn (InFile, LastDate.Month);
			ReadLn (InFile, LastDate.Day);
			ReadLn (InFile, LastDate.Hour);
			ReadLn (InFile, LastDate.Min);
			ReadLn (InFile, LastDate.Sec);
			Close (InFile);

			WriteLn ('INFO: Lastcall file loaded - last log record datetime is: ',
				LastDate.Day:2, '/', LastDate.Month:2, ' ',
				LastDate.Hour:2, ':', LastDate.Min:2, ':', LastDate.Sec:2, '.');

			SetDate := LastDate;
			ProcessOpen := False;
		END;

	FileMode := 0;
	Assign (InFile, TMailLogFile);
	GetMem (TextBuffer, BufferSize);
	SetTextBuf (InFile, TextBuffer^, BufferSize);
	Reset (InFile);

	IF (IOResult <> 0) THEN
		BEGIN
			WriteLn ('ERROR: Unable to open T-Mail log file!');
			Halt;
		END;

	FileListStart := NIL;
	FileListEnd := NIL;
	NewFileListStart := NIL;
	NewFileListEnd := NIL;

	WHILE (NOT Eof (InFile)) DO
		BEGIN
			ReadLn (InFile, InString);

			IF (InString <> '') THEN
				IF (CurrentDateTimeGet (CurrentDate, InString)) THEN
					BEGIN
						IF (NOT ProcessOpen) THEN
							IF (Older (LastDate, CurrentDate)) THEN
								ProcessOpen := True;

						IF (ProcessOpen) THEN
							BEGIN
								LogString := StringExtract (InString, StringWordPos (InString, ' ', 3) - 1, 255);

								FOR i := 1 TO FileReceivedStringCount DO
									IF (StringExtract (LogString, 0, Length (FileReceivedString [i])) = FileReceivedString [i]) THEN
										IF (StringPos (strOK, StringExtract (LogString, StringWordPos (LogString, ' ', 4) - 1, 255), 0) <> 0) THEN
											BEGIN
												FileName := StringWordGet (LogString, ' ', 2);
												FileNameUpCase := StringCase (FileName, Addr (UpperCase));
												j := 1;

												WHILE (j <= IgnoreFilesStringCount) DO
													BEGIN
														IF (StringMatching (FileNameUpCase, IgnoreFilesString [j])) THEN
															Break;

														j := j + 1;
													END;

												IF (j > IgnoreFilesStringCount) THEN
													BEGIN
														IF (NewFileListStart = NIL) THEN
															BEGIN
																NewFileListStart := New (PFile);
																NewFileListEnd := NewFileListStart;
															END
														ELSE
															BEGIN
																NewFileListEnd^.Next := New (PFile);
																NewFileListEnd := NewFileListEnd^.Next;
															END;

														NewFileListEnd^.Next := NIL;
														NewFileListEnd^.FileName := FileName;
													END;

												Break;
											END;

								IF (CharPos ('@', LogString, 0) <> 0) THEN
									IF (ParseAddress (CurrentAddress, StringExtract (LogString, 0, CharPos ('@', LogString, 0) - 1))) THEN
										BEGIN
											WHILE (NewFileListStart <> NIL) DO
												BEGIN
													NewFileListEnd := NewFileListStart;
													Dispose (NewFileListStart);
													NewFileListStart := NewFileListEnd^.Next;
												END;

											NewFileListEnd := NIL;
											NewFileListStart := NIL;
										END;

								IF (LogString [1] = '') THEN
									BEGIN
										SetDate := CurrentDate;

										IF (ParseAddress (CurrentAddress, StringWordGet (LogString, ', ', 2))) THEN
											BEGIN
												CurrentFileBox := FileBoxListStart;

												WHILE (CurrentFileBox <> NIL) DO
													BEGIN
														IF (AddressMatching (CurrentAddress, CurrentFileBox^.Address)) THEN
															Break;

														CurrentFileBox := CurrentFileBox^.Next;
													END;

												IF (NewFileListStart <> NIL) THEN
													BEGIN
														IF (CurrentFileBox <> NIL) THEN
															BEGIN
																CurrentFile := NewFileListStart;

																WHILE (CurrentFile <> NIL) DO
																	BEGIN
																		CurrentFile^.DestinationDirectory := Addr (CurrentFileBox^.Directory);

																		CurrentFile := CurrentFile^.Next;
																	END;

																IF (FileListStart = NIL) THEN
																	BEGIN
																		FileListStart := NewFileListStart;
																		FileListEnd := NewFileListEnd;
																	END
																ELSE
																	BEGIN
																		FileListEnd^.Next := NewFileListStart;
																		FileListEnd := NewFileListEnd;
																	END;
															END
														ELSE
															BEGIN
																WHILE (NewFileListStart <> NIL) DO
																	BEGIN
																		NewFileListEnd := NewFileListStart;
																		Dispose (NewFileListStart);
																		NewFileListStart := NewFileListEnd^.Next;
																	END;
															END;

														NewFileListEnd := NIL;
														NewFileListStart := NIL;
													END;
											END;
									END;
							END;
					END;
		END;

	Close (InFile);
	FreeMem (TextBuffer, BufferSize);

	Assign (InFile, ProgramPath + LastCallFileName);
	Rewrite (InFile);

	IF (IOResult <> 0) THEN
		BEGIN
			WriteLn ('WARNING: Unable to write a lastcall ' + LastCallFileName + ' file!');
		END
	ELSE
		BEGIN
			WriteLn (InFile, SetDate.Year);
			WriteLn (InFile, SetDate.Month);
			WriteLn (InFile, SetDate.Day);
			WriteLn (InFile, SetDate.Hour);
			WriteLn (InFile, SetDate.Min);
			WriteLn (InFile, SetDate.Sec);
			Close (InFile);
		END;
END;

FUNCTION FileCopy (VAR InFile, OutFile: File): Boolean;
VAR
	Buffer: Pointer;
	BytesRead: Word;
BEGIN
	GetMem (Buffer, BufferSize);
	FileCopy := True;

	WHILE (NOT Eof (InFile)) DO
		BEGIN
			BlockRead (InFile, Buffer^, BufferSize, BytesRead);

			IF (IOResult <> 0) THEN
				BEGIN
					WriteLn ('WARNING: Error reading file! Skipping...');
					FileCopy := False;
					Break;
				END;

			BlockWrite (OutFile, Buffer^, BytesRead);

			IF (IOResult <> 0) THEN
				BEGIN
					WriteLn ('WARNING: Error writing file! Skipping...');
					FileCopy := False;
					Break;
				END;
		END;

	FreeMem (Buffer, BufferSize);
END;

PROCEDURE MoveFiles (DeleteIt: Boolean);
VAR
	InFile: File;
	OutFile: File;
	CurrentFile: PFile;
	CurrentDisk: Integer;
	MoveIt: Boolean;
	RemoveFile: Boolean;
	Time: LongInt;
	Attr: Word;
	CurrentIncomingDirectory: Integer;
BEGIN
	IF (FileListStart = NIL) THEN
		BEGIN
			WriteLn ('Nothing to do!');

			Exit;
		END;

	WriteLn;

	IF (DeleteIt) THEN
		WriteLn ('Moving selected files...')
	ELSE
		WriteLn ('Copying selected files...');

	WriteLn;

	CurrentFile := FileListStart;

	WHILE (CurrentFile <> NIL) DO
		BEGIN
			Write ('INFO: ');

			IF (DeleteIt) THEN
				Write ('Moving ')
			ELSE
				Write ('Copying ');

			WriteLn ('"' + CurrentFile^.FileName + '" to ',
				CurrentFile^.DestinationDirectory^ + CurrentFile^.FileName);

			RemoveFile := False;

			FOR CurrentIncomingDirectory := 1 TO IncomingDirectoryStringCount DO
				BEGIN
					FileMode := 0;
					Assign (InFile, IncomingDirectoryString [CurrentIncomingDirectory] + CurrentFile^.FileName);
					GetFAttr (InFile, Attr);
					Reset (InFile, 1);

					IF (IOResult <> 0) THEN
						BEGIN
							IF (CurrentIncomingDirectory = IncomingDirectoryStringCount) THEN
								BEGIN
									WriteLn ('    >>> Unable to open file in any of the incoming directories! Skipping...');
									WriteLn;

									Break;
								END;
						END
					ELSE
						BEGIN
							GetFTime (InFile, Time);

							IF (Length (CurrentFile^.DestinationDirectory^) > 2) AND (CurrentFile^.DestinationDirectory^ [2] = ':') THEN
								BEGIN
									CurrentDisk := Ord (CurrentFile^.DestinationDirectory^ [1]) - 64;
								END
							ELSE
								BEGIN
									CurrentDisk := 0;
								END;

							IF (DiskFree (CurrentDisk) < FileSize (InFile) + 512000) THEN
								BEGIN
									WriteLn ('    >>> Not enough free disk space left! Skipping...');
									WriteLn;
								END
							ELSE
								BEGIN
									IF (OverwriteIncoming) THEN
										BEGIN
											MoveIt := True;
										END
									ELSE
										BEGIN
											FileMode := 0;
											Assign (OutFile, CurrentFile^.DestinationDirectory^ + CurrentFile^.FileName);
											Reset (OutFile, 1);

											IF (IOResult = 0) THEN
												BEGIN
													WriteLn ('    >>> Skipping existing file...');
													WriteLn;

													Close (OutFile);
													MoveIt := False;
												END
											ELSE
												BEGIN
													MoveIt := True;
												END;
										END;

									IF (MoveIt) THEN
										BEGIN
											Assign (OutFile, CurrentFile^.DestinationDirectory^ + CurrentFile^.FileName);
											Rewrite (OutFile, 1);

											IF (IOResult <> 0) THEN
												BEGIN
													WriteLn ('    >>> Unable to overwrite file! Skipping...');
													WriteLn;
												END
											ELSE
												BEGIN
													IF (FileCopy (InFile, OutFile)) THEN
														BEGIN
															RemoveFile := True;
														END;

													SetFTime (OutFile, Time);
													Close (OutFile);
													SetFAttr (OutFile, Attr);
												END;
										END;
								END;

							Close (InFile);

							IF (RemoveFile) AND (DeleteIt) THEN
								DOSFileDelete (IncomingDirectoryString [CurrentIncomingDirectory] + CurrentFile^.FileName);

							Break;
						END;
				END;

			CurrentFile := CurrentFile^.Next;
		END;
END;

PROCEDURE UsageInfoShow;
BEGIN
	WriteLn ('Usage: MOVE2BOX.EXE [command]');
	WriteLn;
	WriteLn ('Where [command] is:');
	WriteLn ('    ' + cmdMove + ' - move incoming files to the fileboxes');
	WriteLn ('    ' + cmdCopy + ' - copy incoming files to the fileboxes');
END;

PROCEDURE ProcessCommands;
VAR
	CommandString: String;
	i: Integer;
BEGIN
	IF (ParamCount < 1) THEN
		BEGIN
			UsageInfoShow;
			Halt;
		END;

	ConfigurationRead;

	FOR i := 1 TO ParamCount DO
		BEGIN
			CommandString := StringCase (ParamStr (i), Addr (UpperCase));

			IF (CommandString = cmdMove) THEN
				BEGIN
					WriteLn ('Executing command "' + cmdMove + '"...');
					WriteLn;

					ProcessLog;
					MoveFiles (True);
				END
			ELSE
				IF (CommandString = cmdCopy) THEN
					BEGIN
						WriteLn ('Executing command "' + cmdCopy + '"...');
						WriteLn;

						ProcessLog;
						MoveFiles (False);
					END
				ELSE
					BEGIN
						WriteLn ('ERROR: Unrecognized command specified!');
						Halt;
					END;

			WriteLn;
			WriteLn ('Done.');
		END;
END;

BEGIN
	WriteLn ('Move2Box v1.4 (c) 1997-99 Seaber Designs');
	WriteLn ('Written by Aleksey V. Vaneev');
	WriteLn;

	DateGet;

	ProgramPath := StringExtract (ParamStr (0), 0, StringWordPos (ParamStr (0), '\', StringWordCount (ParamStr (0), '\')) - 1);

	ProcessCommands;
END.